
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1219.C - Message 1219 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1219 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1219.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:02   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:50:52   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:42   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 14:02:14   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:12   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1219 message from the ZMsgBuf.
//
void Dec1219(tMSGBUF *ZMsgBuf, tMSG1219 *Msg)
{  
   GetBit(&AltInputData.ForceUse       , ZMsgBuf, 7, 0); // 1=force
   GetBit(&AltInputData.MSLSelect      , ZMsgBuf, 7, 1); // 1=MSL
   GetBit(&AltInputData.StoreRAM       , ZMsgBuf, 7, 2); // 1=store
   GetBit(&AltInputData.StoreEEPROM    , ZMsgBuf, 7, 3); // 1=store
   GetBit(&AltInputData.ClearRAM       , ZMsgBuf, 7, 4); // 1=clear
   GetBit(&AltInputData.ClearEEPROM    , ZMsgBuf, 7, 5); // 1=clear
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1219 message in the ZMsgBuf. 
//
void Bld1219(tMSGBUF *ZMsgBuf, tMSG1219 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                   , ZMsgBuf, 1);    // message preamble
   PutShort  (1219                     , ZMsgBuf, 2);    // message number
   PutShort  (6                        , ZMsgBuf, 3);    // message length 
   PutShort  (ANREQ                    , ZMsgBuf, 4);    // message ack/nack request
   
   PutBit(AltInputData.ForceUse        , ZMsgBuf, 7, 0); // 1=force
   PutBit(AltInputData.MSLSelect       , ZMsgBuf, 7, 1); // 1=MSL
   PutBit(AltInputData.StoreRAM        , ZMsgBuf, 7, 2); // 1=store
   PutBit(AltInputData.StoreEEPROM     , ZMsgBuf, 7, 3); // 1=store
   PutBit(AltInputData.ClearRAM        , ZMsgBuf, 7, 4); // 1=clear
   PutBit(AltInputData.ClearEEPROM     , ZMsgBuf, 7, 5); // 1=clear
}                                              
